/*EPS@ISEP 2020 Team 1
 * Project: Floating Trash Collector
*/
//IoT platform identification
String ssid     = "Simulator Wifi";  // SSID to connect to
String password = ""; // Virtual wifi has no password
String host     = "api.thingspeak.com"; // IoT platform Thingspeak API
const int httpPort   = 80;
String uri     = "/update?api_key=6X4HQSBVR094X7YK"; // Floating Trash Collector channel
//SONAR pins
const int trigPin = 9;
const int echoPin = 8;
//SONAR variables
long duration;
int distance;
//Motor pins
int motor_state = 3; // Output to control the motor
int temp_sensor = A0; // Input from the temperature sensor
int level_sensor = A1; // Input from the water level sensor
//Motor variables
int temp; // holds the temperature value, in celsius
int level; // holds the water velvel value, in centimetres
// threshold for the temperature sensor
#define temp_threshold 30
// threshold for the water level sensor
#define level_threshold 40

void motor_setup()
{
  pinMode(motor_state, OUTPUT);  //Output to control the water pump
  //set timer1 interrupt at 1Hz
  TCCR1A = 0;// set entire TCCR1A register to 0
  TCCR1B = 0;// same for TCCR1B
  TCNT1  = 0;//initialize counter value to 0
  // set compare match register for 1hz increments
  OCR1A = 15624;// = (16*10^6) / (1*1024) - 1 (must be <65536)
  // turn on CTC mode
  TCCR1B |= (1 << WGM12);
  // Set CS10 and CS12 bits for 1024 prescaler
  TCCR1B |= (1 << CS12) | (1 << CS10);  
  // enable timer compare interrupt
  TIMSK1 |= (1 << OCIE1A);
  sei();//allow interrupts
}

void SONAR_setup()
{
  pinMode(trigPin, OUTPUT); // Sets the trigPin as an Output
  pinMode(echoPin, INPUT); // Sets the echoPin as an Input
}

ISR(TIMER1_COMPA_vect)
{
  temp = map(analogRead(temp_sensor),20,358,-40,125);
  level = map(analogRead(level_sensor),0,1023,0,40);
  if(level == level_threshold || temp < temp_threshold) // maximum water level
    digitalWrite(motor_state,HIGH); // Activate pump
 
  if(level < level_threshold  || temp > temp_threshold) // minimum water level
    digitalWrite(motor_state,LOW); // Deactivate pump
}

int ESP8266_setup(void) 
{
  // Start ESP8266 Serial Communication
  Serial.begin(115200);   // Serial connection over USB to computer
  Serial.println("AT");   // Serial connection on Tx / Rx port to ESP8266
  delay(10);        // Wait for the ESP to respond (minimum recommended time)
  if (!Serial.find("OK")) return 1;
    
  // Connect to Thinkercad
  Serial.println("AT+CWJAP=\"" + ssid + "\",\"" + password + "\"");
  delay(10);        // Wait for the ESP to respond
  if (!Serial.find("OK")) return 2;
  
  // Open TCP connection to the host
  Serial.println("AT+CIPSTART=\"TCP\",\"" + host + "\"," + httpPort);
  delay(50);        // Wait for the ESP to respond
  if (!Serial.find("OK")) return 3;
  
  return 0;
}

void SONAR_read()
{
  // Clears the trigPin
  digitalWrite(trigPin, LOW);// Set the trigger pin to low for 2uS
  delayMicroseconds(2);
  
  // Sets the trigPin on HIGH state for 10 micro seconds (minimum recommended time)
  digitalWrite(trigPin, HIGH);
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);// Send pin low again
  
  // Reads the echoPin, returns the sound wave travel time in microseconds
  duration = pulseIn(echoPin, HIGH);
  // Calculating the distance in centimeters
  distance= duration*0.034/2;
  
  // Prints the distance on the Serial Monitor
  Serial.print("Distance: ");
  Serial.println(distance);
}

void send_distanceESP8266(void) 
{ 
  SONAR_read();
  
  // Construct our HTTP call
  String httpPacket = "GET " + uri + "&field1=" + String(distance) + "&field2=" + String(digitalRead(motor_state)) + " HTTP/1.1\r\nHost: " + host + "\r\n\r\n";
  int length = httpPacket.length();
  
  // Send our message length
  Serial.print("AT+CIPSEND=");
  Serial.println(length);
  delay(10); // Wait a little for the ESP to respond if (!Serial.find(">")) return -1;

  // Send our http request
  Serial.print(httpPacket);
  delay(10); // Wait a little for the ESP to respond
  if (!Serial.find("SEND OK\r\n")) return;
}

void setup() 
{
  SONAR_setup();
  motor_setup();
  ESP8266_setup();               
}

void loop() 
{ 
  send_distanceESP8266();
  delay(16000); // send data to the IoT platform every 16 seconds (Thingspeak needs 15 seconds)
}
